
import json
from django.http import HttpResponse
from django.urls import reverse
from django.core.exceptions import PermissionDenied
from django.contrib import messages
from django.shortcuts import render,redirect
from webapp.views.base import CommonView,CommonForm,CommonModelForm
from webapp.models import (koleksi as m_koleksi, master as m_master)
from webapp.common import dump, log_activity 

from . import (upload as suratf_upload)

class FormView(CommonView):
	def get(self,request,surat_type,surat_pk=None,form=None):
		surat_type = str(surat_type).upper()
		surat = m_koleksi.Surat.objects.get(_type=surat_type,pk=surat_pk) if surat_pk else None

		allowed_roles = m_master.Roles.objects.exclude(role__startswith='OPERATOR').values_list('role',flat=1)
		allowed_roles = list(allowed_roles)
		if surat and (request.session['role'] in allowed_roles or request.session['pk'] == surat.user_input) == False:
			raise PermissionDenied

		if form is None:
			form = ViewForm(instance=surat)

		form.surat_type_toggle(surat_type)

		form.initial['_type'] = surat_type
		form.initial['pk_surat'] = surat_pk
		form.initial['user_input'] = surat.user_input if surat and surat.user_input else request.session['pk']

		return render(request,'surat/form.html',{
			'berkas': surat.suratf_set.filter(is_deleted=False) if surat else [],
			'surat_pk': surat_pk,
			'surat_type': surat_type,
			'form': form,
		})
	# 
# 

class FormCreateView(FormView):
	def get(self,request,surat_type,form=None):
		return super().get(request,surat_type=surat_type,form=form)
	# 
	def post(self,request,surat_type):
		surat_type = str(surat_type).upper()

		form = ViewForm(request.POST,request.FILES)
		if form.is_valid():
			data = form.save()
			suratf_upload.save_surat_version(data, request.session['pk'])  # ✅ tambahkan ini
			suratf_upload.deploy(request, data.pk, request.FILES.getlist('suratf'))
			messages.info(request, 'berhasil menyimpan data.')
			return redirect('surat_list', surat_type=data._type.lower())
		# 
		return self.get(request,surat_type=surat_type,form=form)
	# 
# 

class FormUpdateView(FormView):
	def get(self,request,surat_type,surat_pk,form=None):
		return super().get(request,surat_type=surat_type,surat_pk=surat_pk,form=form)
	# 
	def post(self,request,surat_type,surat_pk):
		surat_type = str(surat_type).upper()

		data = m_koleksi.Surat.objects.get(_type=surat_type,pk=surat_pk)
		form = ViewForm(request.POST, request.FILES,instance=data)
		log_activity(request, 'edit', 'surat', data.pk, f'Edit surat {data._type.title()} {data.nomor}')
		if form.is_valid():
			surat_obj = m_koleksi.Surat.objects.get(_type=surat_type, pk=surat_pk)
			suratf_upload.save_surat_version(surat_obj, request.session['pk'])
			form.save()
			        # ✅ Ambil ID file yang ditandai hapus (soft delete)
			pending_ids = request.POST.get('pending_delete_ids', '')
			pending_ids = pending_ids.split(',') if pending_ids else []
			if pending_ids:
				m_koleksi.Suratf.objects.filter(pk__in=pending_ids).update(is_deleted=True)
			suratf_upload.deploy(request, surat_obj.pk, request.FILES.getlist('suratf'))
			messages.info(request, 'berhasil mengubah data.')
			return redirect('surat_list', surat_type=surat_type.lower())

		return self.get(request,surat_type=surat_type,surat_pk=surat_pk,form=form)
	#
# 

class ViewForm(CommonModelForm):
	jenis = CommonForm.base().ModelChoiceField(empty_label=None,to_field_name='v',queryset=m_master.Settings.objects.filter(_type='JENIS_SURAT',k='PERMEN_54_2009').values_list('v', flat=1))
	sifat = CommonForm.base().ModelChoiceField(empty_label=None,to_field_name='v',queryset=m_master.Settings.objects.filter(_type='SIFAT_SURAT',k='PERMEN_54_2009').values_list('v', flat=1))
	#start agus 28/4/2025
    # Menambahkan field status_surat dengan pilihan 'public' dan 'private'
	status_surat = CommonForm.base().ChoiceField(
        choices=[('public', 'Public'), ('private', 'Private')],
        required=True,
        label="Status File",
        initial='public'  # default adalah 'public'
    )
	class Meta:
		model = m_koleksi.Surat

		fields = [
			'_type',
			'nomor',
			'tanggal',
			'jenis',
			'sifat',

			'pengirim_nama',
			'pengirim_instansi',

			'penerima_nama',
			'penerima_instansi',

			'perihal',
			'user_input',
			'status_surat',
		]
	#end

		widgets = {
			'_type': CommonForm.base().HiddenInput(),
			'tanggal': CommonForm.base().DateInput(format='%Y-%m-%d')
		}

	def __init__(self,*args,**kwargs):
		super().__init__(*args, **kwargs)

		self.fields['pengirim_nama'].label = 'Nama (Pengirim)'
		self.fields['pengirim_instansi'].label = 'Instansi (Pengirim)'

		self.fields['penerima_nama'].label = 'Nama (Penerima)'
		self.fields['penerima_instansi'].label = 'Instansi (Penerima)'

		self.fields['user_input'].initial = 0
		self.fields['user_input'].widget = CommonModelForm.base().HiddenInput()
	# 
	def surat_type_toggle(self,surat_type):
		if surat_type == 'MASUK':
			self.fields.pop('penerima_nama')
			self.fields.pop('penerima_instansi')
		if surat_type == 'KELUAR':
			self.fields.pop('pengirim_nama')
			self.fields.pop('pengirim_instansi')
	# 
# 
