
from django.http import HttpResponse,HttpResponseRedirect
from django.core.paginator import Paginator
from django.core.exceptions import PermissionDenied
from django.contrib import messages
from django.contrib.postgres.search import SearchVector
from django.shortcuts import render,redirect
from webapp.common import dump
from webapp.models import (koleksi as m_koleksi, master as m_master)

def page_list(request,surat_pk):
	surat = m_koleksi.Surat.objects.get(pk=surat_pk, _type='MASUK')

	allowed_roles = m_master.Roles.objects.exclude(role__startswith='OPERATOR').values_list('role',flat=1)
	allowed_roles = list(allowed_roles)

	page_show = 10
	page_curr = request.GET.get('page')
	page_curr = int(page_curr) if isinstance(page_curr,str) and page_curr.isdigit() == True else 1
	page_curr = 1 if page_curr < 1 else page_curr

	kweri_filter = {}
	page_term = request.GET.get('term','').strip()
	page_term = '' if len(page_term) < 3 else page_term
	if page_term:
		kweri_filter['cari2x'] = page_term

	kweri = m_koleksi.Disposisi.objects.annotate(
		cari2x=SearchVector(
			'sifat',
			'kepada',
			'catatan',
		),
	).filter(
		pk_surat=surat,
		**kweri_filter
	)

	paging = Paginator(kweri,page_show)
	paging = paging.page(page_curr)

	return render(request,'surat/disp_list.html', {
		'page_show': page_show,
		'page_curr': page_curr,
		'page_term': page_term,
		'surat': surat,
		'surat_type': surat._type,
		'allowed_roles': allowed_roles,
		'paging': paging,
	})
# 

def page_item(request,surat_pk,suratd_pk):
	return HttpResponse(None)
# 

def htmlreport(request,page,surat_pk,suratd_pk):
	return render(request,'surat/disp_pdf_v1.html', {
		'disposisi': m_koleksi.Disposisi.objects.get(pk=suratd_pk,pk_surat=surat_pk),
	})
# 

def page_delete(request,surat_pk,suratd_pk):
	allowed_roles = m_master.Roles.objects.exclude(role__startswith='OPERATOR').values_list('role',flat=1)
	allowed_roles = list(allowed_roles)

	data = m_koleksi.Disposisi.objects.get(pk=suratd_pk,pk_surat=surat_pk)

	if request.session['role'] in allowed_roles or request.session['pk'] == data.user_input:
		data.delete();

		messages.warning(request,'berhasil menghapus disposisi surat.')

		referer = request.META.get('HTTP_REFERER',None)
		if referer and '/list' in referer:
			return HttpResponseRedirect(referer)
	else:
		raise PermissionDenied

	redirect('suratdisp_list',surat_pk=surat_pk)
# 
