
from django.http import HttpResponse,HttpResponseRedirect
from django.contrib import messages
from django.shortcuts import render,redirect

from webapp.common import dump
from webapp.views.base import CommonView,CommonForm,CommonModelForm
from webapp.models import (koleksi as m_koleksi, master as m_master)



class FormView(CommonView):
	def get(self,request,surat_pk=None,suratd_pk=None,form=None):

		surat = m_koleksi.Surat.objects.get(_type='MASUK',pk=surat_pk)
		suratd = m_koleksi.Disposisi.objects.get(pk=suratd_pk,pk_surat=surat) if suratd_pk else None

		if form == None:
			form = ViewForm(instance=suratd)

		form.initial['pk_surat'] = surat_pk
		form.initial['user_input'] = suratd.user_input if suratd and suratd.user_input else request.session['pk']

		return render(request, 'surat/d_form.html',{
			'form': form,
			'surat': surat,
			'surat_pk': surat_pk,
			'surat_type': surat._type,
			'suratd': suratd,
			'suratd_pk': suratd_pk,
		})
	# 
# 

class FormCreateView(FormView):
	def get(self,request,surat_pk,form=None):
		return super().get(request,surat_pk=surat_pk,form=form)
	# 

	def post(self,request,surat_pk):
		form = ViewForm(request.POST)

		if form.is_valid():
			data = form.save()
			messages.info(request,'berhasil menambahkan disposisi surat.')
			return redirect('suratdisp_list',surat_pk=surat_pk)
		else:
			return self.get(request,surat_pk=surat_pk,form=form)
	# 
# 

class FormUpdateView(FormView):
	def get(self,request,surat_pk,suratd_pk,form=None):
		return super().get(request,surat_pk=surat_pk,suratd_pk=suratd_pk,form=form)
	# 

	def post(self,request,surat_pk,suratd_pk):
		data = m_koleksi.Disposisi.objects.get(pk=suratd_pk,pk_surat=surat_pk)
		form = ViewForm(request.POST,instance=data)

		if form.is_valid():
			form.save()
			return redirect('suratdisp_list',surat_pk=surat_pk)
		else:
			return self.get(request,surat_pk=surat_pk,suratd_pk=suratd_pk,form=form)
# 

class ViewForm(CommonModelForm):
	class Meta:
		model = m_koleksi.Disposisi

		fields = [
			'pk_surat',
			'tanggal',
			'kepada',
			'catatan',
			'user_input',
		]

		widgets = {
			'pk_surat': CommonForm.base().HiddenInput(),
			'tanggal': CommonForm.base().DateInput(format='%Y-%m-%d'),
			'user_input': CommonForm.base().HiddenInput(),

		}
	# 
	def __init__(self,*args,**kwargs):
		super().__init__(*args, **kwargs)

		self.fields['kepada'].required = True
		self.fields['catatan'].required = True

		self.fields['kepada'].label = 'Disposisi Kepada'
		self.fields['tanggal'].label = 'Tanggal Disposisi'
		self.fields['catatan'].label = 'Catatan Disposisi'
	# 
# 
