
from http import HTTPStatus
from django.http import HttpResponse,JsonResponse,HttpResponseRedirect
from django.core.paginator import Paginator
from django.contrib import messages
from django.shortcuts import render,redirect
from webapp.models import (koleksi as m_koleksi, master as m_master)
from webapp.common import dump


def page_list(request):
	page_show = 10

	page_curr = int(request.GET.get('page',1))
	if page_curr < 1: page_curr = 1;

	q = m_master.Users._read_many(asis=1)
	p = Paginator(q,page_show)
	p = p.page(page_curr)

	return render(request,'master/users/list.html',{
		'result':p,
	})
# 

def page_delete(request,pk):
	if request.session['pk'] == pk:
 		return HttpResponse(None,status=HTTPStatus.BAD_REQUEST)

	m_master.Users._delete(pk=pk)
	messages.warning(request,'berhasil menghapus data.')
	# return redirect('users_create')
	return redirect('users_list')
# 
