
from django.http import HttpResponse,JsonResponse,HttpResponseRedirect
from django.contrib import messages
from django.shortcuts import render,redirect
from webapp.auth import auth_pwd_hash
from webapp.views.base import CommonView,CommonForm,CommonModelForm
from webapp.models import (koleksi as m_koleksi, master as m_master)
from webapp.common import dump

class View(CommonView):
	def get(self,request,pk=None,form=None,is_create=False,is_update=False):
		return render(request,'master/users/form.html',{
			'pk': pk,
			'is_create': is_create,
			'is_update': is_update,
			'form': form,
		})
	# 
# 

class CreateView(View):
	def get(self,request,form=None):
		if form is None: form = Form(is_create=True);

		return super().get(request,pk=None,form=form,is_create=True)
	# 
	def post(self,request):
		data = {k:v for k,v in request.POST.items()}
		form = Form(data,is_create=True)

		if form.is_valid():
			if data['pwd_old'] != data['pwd_new']:
				messages.warning(request,'password tidak sama.')
			else:
				data['pwd'] = auth_pwd_hash(data['pwd_old'])
				del data['pwd_old']
				del data['pwd_new']

				data['pk_roles'] = m_master.Roles._read_one(asis=1,pk=data['pk_roles'])
				users = m_master.Users._create(**data)

				messages.info(request,'berhasil menyimpan data.')
				# return redirect('users_update',pk=users.pk)
				return redirect('users_list')
			# 
		return self.get(request,form=form)
	# 
# 

class UpdateView(View):
	def get(self, request, pk, form=None):
		data = m_master.Users._read_one(pk=pk)
		if form is None: form = Form(is_update=True, initial=data)

		form.initial['pwd'] = None # OKE #

		return super().get(request, pk=pk, form=form, is_update=True)
	# 
	def post(self,request,pk):
		form = None
		user = m_master.Users._read_one(asis=True,pk=pk)
		post = {k:v.strip() for k,v in request.POST.items()}

		if post['pwd'] != '' and post['pwd_old'] != '' and post['pwd_new'] != '':
			if user.pwd != auth_pwd_hash(post['pwd']):
				post['pwd'] = user.pwd
				messages.warning(request,'password lama salah.')
			elif post['pwd_old'] != post['pwd_new']:
				post['pwd'] = user.pwd
				messages.warning(request,'password baru tidak sama.')
			else:
				post['pwd'] = auth_pwd_hash(post['pwd_new'])
		else:
			post['pwd'] = user.pwd
		# 

		form = Form(post,is_update=True,instance=user)
		if form.is_valid():
			form.save()
			messages.info(request,'berhasil menyimpan data.')
			# return redirect('users_update',pk=pk)
			return redirect('users_list')
		# 

		return self.get(request,pk=pk,form=form)
	# 
# 

class Form(CommonModelForm):
	pwd_old = CommonModelForm.base().CharField(required=True,label='Password',widget=CommonForm.base().PasswordInput)
	pwd_new = CommonModelForm.base().CharField(required=True,label='Password',widget=CommonForm.base().PasswordInput)
	class Meta:
		model = m_master.Users
		fields = ['usr','pwd','pk_roles']
	# 
	def __init__(self,*args,is_create=False,is_update=False,**kwargs):
		super().__init__(*args,**kwargs)
		self.fields['usr'].label = 'Username'
		self.fields['pwd'].label = 'Password'
		self.fields['pwd'].widget = CommonModelForm.base().PasswordInput()

		self.fields['pk_roles'].label = 'Peran ...'
		self.fields['pk_roles'].empty_label = 'Peran ...'
		self.fields['pk_roles'].label_from_instance = lambda roles: "%s" % roles.role

		if is_create:
			self.fields['pwd'].required = False
			self.fields['pwd_new'].label = 'Ulangi Password';
		# 
		if is_update:
			self.fields['pwd'].required = False
			self.fields['pwd_old'].required = False
			self.fields['pwd_new'].required = False

			self.fields['pwd'].label = 'Password Lama';
			self.fields['pwd_old'].label = 'Password Baru';
			self.fields['pwd_new'].label = 'Ulangi Password Baru';
		# 
	# 
# 
