
import os,json
from django.conf import settings
from django.core.paginator import Paginator
from django.utils import html
from django.http import HttpResponse,HttpResponseRedirect
from django.shortcuts import render,redirect

from webapp.views.base import CommonView,CommonForm,CommonModelForm
from webapp.models import (koleksi as m_koleksi, master as m_master)
from webapp.common import dump

PATH_DIR = os.path.join(settings.BASE_DIR,'assets','upload')

class MainView(CommonView):
	def get(self,request):
		settings_main = m_master.Settings.objects.filter(_type=None).distinct('k').order_by('k').values('pk','k','v','note')
		settings_main = [i for i in settings_main]
		return render(request,'master/settings_main.html', {
			'settings_main': settings_main,
		})
	# 
	def post(self,request):
		post = request.POST
		for i in post:
			for j in m_master.Settings.objects.filter(_type=None,k=i):
				j.v = html.escape(str(post[i]).strip())
				j.save()
		file = request.FILES
		for i in file:
			with open(os.path.join(PATH_DIR,i), 'wb+') as buffer:
				for chunk in file[i].chunks():
					buffer.write(chunk)
		if request.is_ajax(): return HttpResponse(None);
		else: return redirect('settings_main')
		
	# 
# 

def log_activity(request):
    search_action = request.GET.get('action', '')
    sorting = request.GET.get('sorting', 'desc')
    search_term = request.GET.get('term', '')
    search_category = request.GET.get('category', '').lower()

    logs_all = m_master.AuditLog.objects.select_related('user')

    if search_action:
        logs_all = logs_all.filter(action__iexact=search_action)

    if search_term:
        logs_all = logs_all.filter(description__icontains=search_term)

    # ✅ Tambahkan filter berdasarkan kategori (jenis file)
    if search_category == 'surat masuk':
        logs_all = logs_all.filter(description__icontains='masuk', content_type='surat')
    elif search_category == 'surat keluar':
        logs_all = logs_all.filter(description__icontains='keluar', content_type='surat')
    elif search_category == 'dokumen':
        logs_all = logs_all.filter(content_type='contents')
    elif search_category == 'disposisi':
        logs_all = logs_all.filter(content_type='disposisi')

    if sorting == 'asc':
        logs_all = logs_all.order_by('timestamp')
    else:
        logs_all = logs_all.order_by('-timestamp')

    paginator = Paginator(logs_all, 10)
    page_number = request.GET.get('page')
    logs = paginator.get_page(page_number)

    action_list = (
        m_master.AuditLog.objects
        .order_by('action')
        .values_list('action', flat=True)
        .distinct()
    )

    return render(request, 'master/settings_activity.html', {
        'logs': logs,
        'action_list': action_list,
        'search_action': search_action,
        'search_term': search_term,
        'sorting': sorting,
        'search_category': search_category,  # dikirim ke template untuk selected
    })
