
from django.core.paginator import Paginator
from django.core.exceptions import PermissionDenied
from django.http import Http404,HttpResponse,HttpResponseRedirect
from django.contrib import messages
from django.contrib.postgres.search import SearchVector
from django.shortcuts import render,redirect
from webapp.models import (koleksi as m_koleksi, master as m_master)
from webapp.func import dump
from webapp.common import log_activity

def page_list(request):
	display = request.GET.get('disp','list')
	page_show = request.GET.get('item_jml',6)
	sorting = request.GET.get('sorting', 'desc')

	page_curr = request.GET.get('page')
	page_curr = int(page_curr) if isinstance(page_curr,str) and page_curr.isdigit() == True else 1
	page_curr = 1 if page_curr < 1 else page_curr

	kweri_filter = {}
	page_term = request.GET.get('term','').strip()
	page_term = '' if len(page_term) <=3 else page_term
	if page_term:
		kweri_filter['cari2x__icontains'] = page_term

	if sorting == 'desc':
		kweri = m_koleksi.Disposisi.objects.annotate(
			cari2x=SearchVector(
				'sifat',
				'kepada',
				'catatan',
			),
		).filter(
			pk_surat=None,
			**kweri_filter
		).order_by('-created')
	else:
		kweri = m_koleksi.Disposisi.objects.annotate(
			cari2x=SearchVector(
				'sifat',
				'kepada',
				'catatan',
			),
		).filter(
			pk_surat=None,
			**kweri_filter
		).order_by('created')

	paging = Paginator(kweri,page_show)
	paging = paging.page(page_curr)

	allowed_roles = m_master.Roles.objects.exclude(role__startswith='OPERATOR').values_list('role',flat=1)
	allowed_roles = list(allowed_roles)

	return render(request,'disp/list.html',{
		'page_term': page_term,
		'allowed_roles': allowed_roles,
		'paging': paging,
		'display': display,
		'show' : page_show,
		'sorting':sorting,
	})

def page_item(request,disposisi_pk):
	return render(request,'disp/item.html')
# 

def htmlreport(request,page,pk):
	data = m_koleksi.Disposisi.objects.get(pk=pk)

	if page == 'v1':
		return render(request,'disp/pdf_v1.html',{
			'disposisi': data,
			'sifat': data.sifat,
			'perihal': data.catatan,
		})

	raise Http404
# 

def page_delete(request,disp_pk):
	allowed_roles = m_master.Roles.objects.exclude(role__startswith='OPERATOR').values_list('role',flat=1)
	allowed_roles = list(allowed_roles)

	data = m_koleksi.Disposisi.objects.get(pk=disp_pk)

	if request.session['role'] in allowed_roles or (request.session['pk'] == data.user_input):
		log_activity(
        request,
        'delete',
        'disposisi',
        data.pk,
        f'Hapus disposisi kepada {data.kepada}'
    )

		data.delete()
		messages.warning(request,'berhasil hapus data.')

		hredirect = request.META.get('HTTP_REFERER',None)
		if hredirect and '/list' in hredirect:
			return HttpResponseRedirect(hredirect)
	else:
		raise PermissionDenied

	return redirect('disp_list')
# 
