
from django.http import HttpResponse,HttpResponseRedirect
from django.contrib import messages
from django.shortcuts import render,redirect
from django.urls import reverse

from webapp.common import dump, log_activity
from webapp.views.base import CommonView,CommonForm,CommonModelForm
from webapp.models import (koleksi as m_koleksi, master as m_master)


class FormView(CommonView):
	def get(self,request, disp_pk=None ,form=None):
		if form is None:
			if disp_pk is None:
				form = ViewForm()
			else:
				dispo_read = m_koleksi.Disposisi._read_one(pk=disp_pk)
				if dispo_read['user_input'] != request.session.get('pk') and request.session.get('role') not in ['ADMIN', 'KOORDINATOR']:
					return render(request, 'forbidden.html',{'urlnya':reverse('disp_list')})
				else:
					form = ViewForm(instance=m_koleksi.Disposisi.objects.get(pk=disp_pk))

		return render(request, 'disp/form.html',{
			'form': form,
			'disp_pk': disp_pk,
		})
	# 
# 

class FormCreateView(FormView):
	def get(self,request,form=None):
		return super().get(request)
	# 
	def post(self,request):
		post = {k:v for k,v in request.POST.items()}
		post['user_input'] = request.session.get('pk')

		form = ViewForm(post)

		if form.is_valid():
			data = form.save()

			log_activity(
        request,
        'upload',
        'disposisi',
        data.pk,
        f'Tambah disposisi kepada {data.kepada}'
   		 )	


			messages.info(request,'berhasil menyimpan data.')
			return redirect('disp_list')
		else:
			return self.get(request,form=form)
	# 
# 

class FormUpdateView(FormView):
    def get(self, request, disp_pk, form=None):
        return super().get(request, disp_pk=disp_pk, form=form)

    def post(self, request, disp_pk):
        post = {k: v for k, v in request.POST.items()}
        form = ViewForm(post, instance=m_koleksi.Disposisi.objects.get(pk=disp_pk))

        if form.is_valid():
            form.save()
            
            # ✅ Catat log aktivitas
            log_activity(
                request,
                'edit',
                'disposisi',
                disp_pk,
                f"Edit disposisi kepada {form.cleaned_data.get('kepada', '-')}"
            )

            messages.info(request, 'berhasil mengubah data.')
            return redirect('disp_list')
        else:
            return self.get(request, disp_pk, form)


class ViewForm(CommonModelForm):
	sifat = CommonForm.base().ModelChoiceField(empty_label=None,to_field_name='v',queryset=m_master.Settings.objects.filter(_type='SIFAT_SURAT',k='PERMEN_54_2009').values_list('v', flat=1))

	class Meta:
		model = m_koleksi.Disposisi

		fields = [
			'tanggal',
			'sifat',
			'kepada',
			'catatan',
			'user_input',
		]

		widgets = {
			'tanggal': CommonForm.base().DateInput(format='%Y-%m-%d')
		}

	def __init__(self,*args,**kwargs):
		super().__init__(*args, **kwargs)

		self.fields['sifat'].label = 'Sifat Disposisi'
		self.fields['kepada'].label = 'Diteruskan Kepada'
		self.fields['catatan'].label = 'Catatan Disposisi'
		self.fields['tanggal'].label = 'Tanggal Disposisi'
		self.fields['user_input'].initial = 0
		self.fields['user_input'].widget = CommonModelForm.base().HiddenInput()
		self.fields['kepada'].required = True
		self.fields['catatan'].required = True
	# 
# 
