
import json
from django.http import HttpResponse,HttpResponseRedirect
from django.contrib import messages
from django.shortcuts import render,redirect
from webapp.views.base import CommonView,CommonForm,CommonModelForm
from webapp.models import (koleksi as m_koleksi, master as m_master)
from webapp.common import dump

class FormCreateView(CommonView):
	def get(self,request,form=None):
		if form == None:
			form = FormHandle()

		return render(request,'catetree/form.html',{
			'form': form,
			'parents': m_koleksi.Categories._recursive(pk_parent=0,deep=0),
		})
	# 

	def post(self,request):
		form = FormHandle(request.POST)
		if form.is_valid():
			values = {k:v for k,v in request.POST.items()}

			categories = m_koleksi.Categories._create(**values)

			messages.info(request,'berhasil menyimpan data.')
			# return redirect('catetree_update', pk=categories.pk)
			return redirect('catetree_list')
		# 
		return self.get(request,form=form)
	# 
# 

class FormUpdateView(CommonView):
	def get(self,request,pk,form=None):
		if form == None:
			form = FormHandle()

		data = m_koleksi.Categories._read_one(pk=pk)
		if 'sort' in data:
			data['sort'] = str(data['sort'])

		for k,v in data.items():
			if k in form.fields:
				form.fields[k].initial = v

		return render(request,'catetree/form.html',{
			'pk': pk,
			'form': form,
			'parents': m_koleksi.Categories._recursive(pk_parent=0,deep=0,pk__nexact=pk),
		})
	# 
	def post(self,request,pk):
		form = FormHandle(request.POST)

		if form.is_valid():
			values = {k:v for k,v in request.POST.items()}
			keys = dict(pk=pk)

			m_koleksi.Categories._update(values,keys)

			messages.info(request,'berhasil mengubah data.')

		# return self.get(request,pk=pk,form=form)
		return redirect('catetree_list')
	# 
# 

class FormHandle(CommonModelForm):
	class Meta:
		model = m_koleksi.Categories
		fields = ['pk_parent','text','sort','attributes']

	def __init__(self,*args,**kwargs):
		super().__init__(*args, **kwargs)

		root = m_koleksi.Categories._read_one(asis=1,pk_parent=None)
		self.fields['pk_parent'].label = root.text
		self.fields['pk_parent'].initial = root.pk
		self.fields['text'].label = 'Kategori'
		self.fields['sort'].label = 'Urutan'
	# 
# 
