from django.shortcuts import render
from .forms import UploadPDFForm
from .utils import upload_to_drive
import io

def upload_pdf(request):
    link_drive = None
    if request.method == 'POST':
        form = UploadPDFForm(request.POST, request.FILES)
        if form.is_valid():
            file = request.FILES['file']
            file_io = io.BytesIO(file.read())
            file_io.seek(0)
            link_drive = upload_to_drive(file_io, file.name)
    else:
        form = UploadPDFForm()
    
    return render(request, 'upload/upload.html', {'form': form, 'link': link_drive})
