import io
from google.oauth2 import service_account
from googleapiclient.discovery import build
from googleapiclient.http import MediaIoBaseUpload

def upload_to_drive(file_obj, filename):
    SERVICE_ACCOUNT_FILE = 'credentials/drive_service_account.json'
    SCOPES = ['https://www.googleapis.com/auth/drive']
    FOLDER_ID = '19pH19iCJ8hNr9OF0TwyWwMiKeR-_iecS'  # Ganti sesuai kebutuhan

    credentials = service_account.Credentials.from_service_account_file(
        SERVICE_ACCOUNT_FILE, scopes=SCOPES)

    service = build('drive', 'v3', credentials=credentials)

    file_metadata = {
        'name': filename,
        'parents': [FOLDER_ID]
    }

    media = MediaIoBaseUpload(file_obj, mimetype='application/pdf')

    file = service.files().create(
        body=file_metadata,
        media_body=media,
        fields='id, webViewLink'
    ).execute()

    return file.get('webViewLink')
