
# from django.contrib import admin
from django.urls import path,include
from webapp import auth
from webapp.views import main,surat
from webapp.views.disp import (main as disp_main, form as disp_form)
from webapp.views.fileman import (main as fileman_main, form as fileman_form)
from webapp.views.catetree import (main as catetree_main, form as catetree_form)
from webapp.views.master import (settings as settings_page)
from webapp.views.master.users import (form as users_form, main as users_main)
from webapp.views.fileman.form import predict_category_tags

from django.conf import settings
from django.conf.urls.static import static


handler403 = 'webapp.views.main.page403'
handler404 = 'webapp.views.main.page404'

urlpatterns = [
	path('', main.home, name='/'),

	path('403', main.page403, name='403'),
	path('404', main.page404, name='404'),

	path('login', auth.AuthLoginView.as_view(), name='login'),
	path('logout', auth.AuthLogoutView.as_view(), name='logout'),
	path('dash', main.dash, name='dash'),
    path('convert-to-word/', main.convert_to_word, name='convert_to_word'),
	path('convert-to-images/', main.convert_to_images, name='convert_to_images'),
	path('upload-drive/', main.upload_pdf_to_drive, name='upload_to_drive'),

	path('surat/delete/<str:_type>/<int:pk>', surat.main.page_delete, name='surat_delete'),
	path('surat/deletef/<int:pk>', surat.main.page_deletef, name='surat_deletef'),

	path('surat/<str:surat_type>/list', surat.main.page_list, name='surat_list'),
	path('surat/<str:surat_type>/item/<int:surat_pk>', surat.main.page_item, name='surat_item'),
	path('surat/<str:surat_type>/form1/create', surat.form.FormCreateView.as_view(), name='surat_create'),
	path('surat/<str:surat_type>/form1/update/<int:surat_pk>', surat.form.FormUpdateView.as_view(), name='surat_update'),
    path('surat/history/<int:surat_pk>', surat.main.page_history, name='surat_history'),
	path('surat/rollback/<int:surat_pk>/<int:version_id>', surat.main.page_rollback, name='surat_rollback'),


	path('disposisi/', include([
		path('list', disp_main.page_list, name='disp_list'),
		path('item/<int:disp_pk>', disp_main.page_item, name='disp_item'),
		path('form/', include([
			path('create', disp_form.FormCreateView.as_view(), name='disp_create'),
			path('update/<int:disp_pk>', disp_form.FormUpdateView.as_view(), name='disp_update'),
		])),
		path('delete/<int:disp_pk>', disp_main.page_delete, name='disp_delete'),
		path('htmlreport/<str:page>/<int:pk>',disp_main.htmlreport, name='disp_htmlreport'),
	])),

	path('surat/disposisi/', include([
		path('<int:surat_pk>/list', surat.disp_main.page_list, name='suratdisp_list'),
		path('<int:surat_pk>/form/create', surat.d_form.FormCreateView.as_view(), name='suratd_create'),
		path('<int:surat_pk>/form/update/<int:suratd_pk>', surat.d_form.FormUpdateView.as_view(), name='suratd_update'),
		path('<int:surat_pk>/delete/<int:suratd_pk>', surat.disp_main.page_delete, name='suratd_delete'),
		path('<int:surat_pk>/delete/<int:suratd_pk>', surat.disp_main.page_delete, name='suratd_delete'),
		path('htmlreport/<str:page>/<int:surat_pk>/<int:suratd_pk>', surat.disp_main.htmlreport, name='suratd_htmlreport'),
	])),

	path('berkas/', include([
		path('list', fileman_main.page_list, name='content_list'),
		path('list/<int:pk>', fileman_main.page_list, name='content_list'),
		path('item/<int:pk>', fileman_main.page_item, name='content_item'),
        path('item/tags/<str:tag_name>', fileman_main.page_tag_detail, name='tag_detail'),
        
        path('convert-to-word/', fileman_main.convert_to_word, name='convert_to_word'),
        path('convert-to-images/', fileman_main.convert_to_images, name='convert_to_images'),
        path('upload-drive/', fileman_main.upload_pdf_to_drive, name='upload_to_drive'),
        path('item/<int:pk>/histori', fileman_main.page_history, name='content_history'),
        path('rollback/<int:pk>', fileman_form.rollback_version, name='content_rollback'),
        path('predict-category-tags/', predict_category_tags, name='predict_category_tags'),


		path('form/', include([
			path('create', fileman_form.UploadFormCreateView.as_view(), name='content_create'),
			path('update/<int:pk>', fileman_form.UploadFormUpdateView.as_view(), name='content_update'),
			path('delete/<int:pk>', fileman_form.delete, name='content_delete'),
		])),
		path('remove/<int:pk>', fileman_form.remove, name='content_attachment_remove'),
	])),

	path('categories/', include([
		path('list', catetree_main.page_list, name='catetree_list'),
		path('form/', include([
			path('create', catetree_form.FormCreateView.as_view(), name='catetree_create'),
			path('update/<int:pk>', catetree_form.FormUpdateView.as_view(), name='catetree_update'),
		])),
		path('delete/<int:pk>', catetree_main.page_delete, name='catetree_delete'),
	])),

	path('settings/', include([
		path('main', settings_page.MainView.as_view(), name='settings_main'),
    path('aktivitas', settings_page.log_activity, name='log_activity'),  # 👈 ini tambahan untuk log aktivitas

	])),

	path('users/', include([
		path('list', users_main.page_list, name='users_list'),
		path('delete/<int:pk>', users_main.page_delete, name='users_delete'),
		path('form/', include([
			path('create', users_form.CreateView.as_view(), name='users_create'),
			path('update/<int:pk>', users_form.UpdateView.as_view(), name='users_update'),
		])),
	])),

	path('generate_thumb/', main.generate_thumbnail, name='generate_thumbnail'),
    
	
] + static(settings.MEDIA_URL, document_root=settings.MEDIA_ROOT)
