
import json,datetime

from django import template
from django.utils.safestring import mark_safe
from django.utils.dateparse import parse_date,parse_datetime
from django.db.models.query import QuerySet
from django.core import serializers

from webapp import *

register = template.Library()

@register.filter(name='dump')
def dump_fiter(data):
	dump(data)
# 

@register.filter
def stringf1(a,b):
	return a % b
# 

@register.filter(name='json')
def json_filter(data):
	if isinstance(data,QuerySet):
		return mark_safe(serializers.serialize('json',data))
	return mark_safe(json.dumps(data))
# 

@register.filter
def stringDateYMD(date_string):
	if date_string is str: return parse_date(date_string)
	if isinstance(date_string,datetime.date): return date_string.isoformat()
	return date_string
# 

def stringDateYMDHIS(date_string):
	return parse_datetime(date_string)
# 
