
import os

DEBUG = False
ALLOWED_HOSTS = ['localhost','127.0.0.1']

BASE_DIR = os.path.dirname(os.path.dirname(os.path.abspath(__file__)))
MAIN_DIR = os.path.dirname(os.path.abspath(__file__))
FILE_FIR = None # LOKASI UPLOAD #

AUTORUN_CUSTOM_MIGRATE = False # UNTUK ~/migrates/ OTOMATIS #

ROOT_URLCONF = 'webapp.urls'
WSGI_APPLICATION = 'webapp.wsgi.application'

STATIC_URL = '/assets/'
STATICFILES_DIRS = [
	os.path.join(BASE_DIR,'assets','packages'),
	os.path.join(BASE_DIR,'assets'),
]

MEDIA_URL = '/media/'
MEDIA_ROOT = os.path.join(BASE_DIR, 'media')

# STATICFILES_STORAGE = 'whitenoise.storage.CompressedManifestStaticFilesStorage' # +gzip +cache +root #
# STATICFILES_STORAGE = 'whitenoise.storage.CompressedStaticFilesStorage' # +gzip -cache -root #

WHITENOISE_AUTOREFRESH = True
WHITENOISE_USE_FINDERS = True
WHITENOISE_MAX_AGE = 3600

DATABASES = {
	'default': {
		'ENGINE': 'django.db.backends.postgresql',
		'PORT': 5432,
		'HOST': 'localhost',
		'NAME': 'smf',
		'USER': 'postgres',
		'PASSWORD': 'postgres',
		'OPTIONS': {
			# "options":"-c search_path=public", #
		},
	},
}

INSTALLED_APPS = [
	# 'django.contrib.admin', # ABAIKAN #
	'django.contrib.auth',
	'django.contrib.contenttypes',
	'django.contrib.sessions',
	'django.contrib.messages',
	'whitenoise.runserver_nostatic', # HARUS DISINI, SEBELUM staticfiles. #
	'django.contrib.staticfiles',
	'django.contrib.postgres',
	'django_extensions',
	'widget_tweaks',
	'webapp',
]

MIDDLEWARE = [
	'django.middleware.security.SecurityMiddleware',
	'whitenoise.middleware.WhiteNoiseMiddleware', # HARUS DISINI, SETELAH SecurityMiddleware. #
	'django.contrib.sessions.middleware.SessionMiddleware',
	'django.middleware.common.CommonMiddleware',
	'django.middleware.csrf.CsrfViewMiddleware',
	'django.contrib.auth.middleware.AuthenticationMiddleware',
	'django.contrib.messages.middleware.MessageMiddleware',
	'django.middleware.clickjacking.XFrameOptionsMiddleware',
	'webapp.auth.AuthMiddleware',
]

TEMPLATES = [
	{
		'BACKEND': 'django.template.backends.django.DjangoTemplates',
		'APP_DIRS': True,
		'DIRS': [
			os.path.join(MAIN_DIR,'templates'),
		],
		'OPTIONS': {
			'context_processors': [
				'django.template.context_processors.debug',
				'django.template.context_processors.request',
				'django.contrib.auth.context_processors.auth',
				'django.contrib.messages.context_processors.messages',
				'webapp.common.template_variables',
			],
		},
	},
]

SECRET_KEY = 'how1zn!($%ynd=p_=cmi-$fmdd27ct@=nze4rdi8=ho3l(im%e' # DONT UBAH #

AUTH_PASSWORD_VALIDATORS = [
	{'NAME': 'django.contrib.auth.password_validation.UserAttributeSimilarityValidator'},
	{'NAME': 'django.contrib.auth.password_validation.MinimumLengthValidator'},
	{'NAME': 'django.contrib.auth.password_validation.CommonPasswordValidator'},
	{'NAME': 'django.contrib.auth.password_validation.NumericPasswordValidator'},
]

SESSION_ENGINE = 'django.contrib.sessions.backends.signed_cookies'
SESSION_COOKIE_NAME = 'GIN_SMF_WEBAPP'
SESSION_COOKIE_AGE = 86400

LANGUAGE_CODE = 'id-ID'

TIME_ZONE = 'Asia/Jakarta'
USE_TZ = True

USE_I18N = True
USE_L10N = True
