
"""
ingat
fields(pk,is,type,dst,reserved-words) ndak bisa d pake, jadi harus pake alias.
dengan cara prefix "_" (underscore) n kasi prop "db_column" dengan nama field asli.
"""

from django.db import models
from .base import CommonModel,RecursiveModel
from webapp.func import dump

class Roles(CommonModel):
	_pk = models.AutoField(db_column='pk',primary_key=True)
	role = models.CharField(unique=True, max_length=128)
	note = models.TextField(blank=True, null=True)

	class Meta:
		managed = False
		db_table = 'roles'
	# 
# 

class Users(CommonModel):
	_pk = models.AutoField(db_column='pk',primary_key=True)
	pk_roles = models.ForeignKey('Roles', models.DO_NOTHING, db_column='pk_roles')
	usr = models.CharField(unique=True, max_length=128)
	pwd = models.CharField(max_length=256)
	class Meta:
		managed = False
		db_table = 'users'
		ordering = ['updated','created']
	# 
# 

class Settings(CommonModel):
	_pk = models.AutoField(db_column='pk',primary_key=True)
	_type = models.CharField(db_column='type',max_length=128, blank=True, null=True)
	k = models.CharField(max_length=128, blank=True, null=True)
	v = models.CharField(max_length=512, blank=True, null=True)
	note = models.CharField(max_length=256, blank=True, null=True)
	@classmethod
	def _default(self):
		result = {}
		for i in self.objects.filter(_type=None).values():
			result[i['k']] = i['v']
		return result
	# 
	class Meta:
		managed = False
		db_table = 'settings'
	# 
# 

class Menus(RecursiveModel):
	_pk = models.AutoField(db_column='pk',primary_key=True)
	pk_parent = models.IntegerField()
	_type = models.CharField(db_column='type',max_length=64)
	text = models.CharField(max_length=256, blank=True, null=True)
	href = models.CharField(max_length=512, blank=True, null=True)
	icon = models.CharField(max_length=128, blank=True, null=True)
	sort = models.IntegerField()
	_is = models.BooleanField(db_column='is')
	extra = models.TextField(blank=True, null=True)
	class Meta:
		managed = False
		db_table = 'menus'
		unique_together = (('_type','href'),)
		ordering = ['sort','text']
	# 
# 

class Access(CommonModel):
	_pk = models.AutoField(db_column='pk',primary_key=True)
	roles_pk = models.ForeignKey('Roles', models.DO_NOTHING, db_column='roles_pk')
	menus_pk = models.ForeignKey('Menus', models.DO_NOTHING, db_column='menus_pk')
	users_pk = models.ForeignKey('Users', models.DO_NOTHING, db_column='users_pk', blank=True, null=True)
	_is = models.BooleanField(db_column='is', blank=True, null=True)
	class Meta:
		managed = False
		db_table = 'access'
		unique_together = (('roles_pk', 'menus_pk'), ('roles_pk', 'menus_pk', 'users_pk'),)
	# 
	@classmethod
	def _menus_validate(self,menus_pk=None,roles_pk=None,users_pk=None):
		by_role = self.objects.filter(menus_pk=menus_pk,roles_pk=roles_pk).first()
		by_user = self.objects.filter(menus_pk=menus_pk,roles_pk=roles_pk,users_pk=users_pk).first()

		if by_role and by_role._is:
			if by_user:
				if by_user._is:
					return True
			else:
				return True

		return False
	# 
# 

class Ta(CommonModel):
    tahun = models.IntegerField(primary_key=True)
    current = models.BooleanField(blank=True, null=True)
    class Meta:
        managed = False
        db_table = 'ta'
        ordering = ['-tahun']
    # 
#
class Skpddg(CommonModel):
	_pk = models.AutoField(db_column='pk',primary_key=True)
	kd_urusan = models.IntegerField()
	kd_bidang = models.IntegerField()
	kd_unit = models.IntegerField()
	kd_sub = models.IntegerField()
	kd_all = models.CharField(max_length=256, blank=True, null=True)
	urai = models.CharField(max_length=256, blank=True, null=True)
	class Meta:
		managed = False
		db_table = 'skpd_dg'
		ordering = ['kd_urusan','kd_bidang','kd_unit','kd_sub']
	# 
# 
class AuditLog(models.Model):
    log_id = models.AutoField(primary_key=True)
    user = models.ForeignKey(
        'Users',  # ganti jika model Users kamu di lokasi lain
        db_column='user_id',
        on_delete=models.SET_NULL,
        null=True
    )
    action = models.CharField(max_length=50)
    content_type = models.CharField(max_length=100, blank=True, null=True)
    object_pk = models.IntegerField(blank=True, null=True)
    description = models.TextField(blank=True, null=True)
    timestamp = models.DateTimeField()

    class Meta:
        managed = False  # karena tabel sudah ada di database
        db_table = 'audit_logs'
        ordering = ['-timestamp']
