
from django.db import models
from .base import CommonModel,RecursiveModel
from django.contrib.postgres.fields import JSONField
from django.contrib.postgres.fields import ArrayField

class Contents(CommonModel):
	_pk = models.AutoField(db_column='pk',primary_key=True)
	pk_categories = models.ForeignKey('Categories', models.DO_NOTHING, db_column='pk_categories', blank=True, null=True)
	pk_skpd_dg = models.ForeignKey('Skpddg', models.DO_NOTHING, db_column='pk_skpd_dg', blank=True, null=True)
	tahun = models.ForeignKey('Ta', models.DO_NOTHING, db_column='tahun')
	judul = models.CharField(max_length=256, blank=True, null=True)
	deskripsi = models.TextField(blank=True, null=True)
	attributes = models.TextField(blank=True, null=True)
	user_input = models.TextField(blank=False, null=False)
	#start agus 28/04/2025
	STATUS_CHOICES = [
        ('public', 'Public'),  # Menyimpan 'public' di database, menampilkan 'Public' kepada pengguna
        ('private', 'Private'),  # Menyimpan 'private' di database, menampilkan 'Private' kepada pengguna
    ]
	status_konten = models.CharField(max_length=20, choices=STATUS_CHOICES, default='public')  # Default adalah Public
	#end
	class Meta:
		managed = False
		db_table = 'contents'
		# ordering = ['-updated','-created']
	# 
# 


class ContentVersion(models.Model):
    _pk = models.AutoField(db_column='pk', primary_key=True)
    pk_contents = models.IntegerField()
    judul = models.CharField(max_length=256, blank=True, null=True)
    deskripsi = models.TextField(blank=True, null=True)
    attributes = models.TextField(blank=True, null=True)
    # attributes = JSONField(blank=True, null=True)
    tahun = models.IntegerField(blank=True, null=True)
    pk_categories = models.IntegerField(blank=True, null=True)
    pk_skpd_dg = models.IntegerField(blank=True, null=True)
    status_konten = models.CharField(max_length=64, blank=True, null=True)
    created = models.DateTimeField(auto_now_add=True)
    user_input = models.IntegerField(default=0)
    tags = ArrayField(models.CharField(max_length=64), blank=True, null=True)

    class Meta:
        managed = False
        db_table = 'content_versions'

class ContentVersionAttachment(models.Model):
    _pk = models.AutoField(db_column='pk', primary_key=True)
    pk_version = models.ForeignKey('ContentVersion', db_column='pk_version', on_delete=models.CASCADE)
    name = models.CharField(max_length=256)
    path = models.TextField()
    content_type = models.CharField(max_length=64, blank=True, null=True)
    size = models.IntegerField(blank=True, null=True)
    created = models.DateTimeField(auto_now_add=True)

    class Meta:
        managed = False
        db_table = 'content_version_attachments'


class Attachments(CommonModel):
	_pk = models.AutoField(db_column='pk',primary_key=True)
	pk_contents = models.ForeignKey('Contents', models.DO_NOTHING, db_column='pk_contents') # MALES PAKEK #
	name = models.CharField(max_length=256, blank=True, null=True)
	path = models.CharField(max_length=512, blank=True, null=True)
	_type = models.CharField(db_column='type',max_length=128, blank=True, null=True)
	size = models.IntegerField(blank=True, null=True)
	is_deleted = models.BooleanField(default=False)
	class Meta:
		managed = False
		db_table = 'attachments'
	# 
	@classmethod
	def deploy(self,pk,attachments):
		# todo #
		pass
	# 
	@classmethod
	def destroy(self,*args):
		# todo #
		pass
	# 

	def split_as_png(self):
		return self.path.split('.pdf')
# 

class Categories(RecursiveModel):
	text = models.CharField(max_length=256, blank=True, null=True)
	sort = models.IntegerField()
	attributes = models.TextField(blank=True, null=True)
	class Meta:
		managed = False
		db_table = 'categories'
		ordering = ['sort','text']
	# 
# 

class Surat(CommonModel):
	_pk = models.AutoField(db_column='pk',primary_key=True)
	_type = models.CharField(db_column='type',max_length=64)
	nomor = models.CharField(max_length=128)
	tanggal = models.DateField()
	pengirim = models.CharField(max_length=128, blank=True, null=True)
	pengirim_nama = models.CharField(max_length=128, blank=True, null=True)
	pengirim_instansi = models.CharField(max_length=256, blank=True, null=True)
	penerima = models.CharField(max_length=128, blank=True, null=True)
	penerima_nama = models.CharField(max_length=128, blank=True, null=True)
	penerima_instansi = models.CharField(max_length=256, blank=True, null=True)
	sifat = models.CharField(max_length=64, blank=True, null=True)
	jenis = models.CharField(max_length=64, blank=True, null=True)
	perihal = models.TextField(blank=True, null=True)
	user_input = models.CharField(max_length=128, blank=False, null=False)
	#start agus 28/4/2025
	STATUS_CHOICES = [
        ('public', 'Public'),  # Menyimpan 'public' di database, menampilkan 'Public' kepada pengguna
        ('private', 'Private'),  # Menyimpan 'private' di database, menampilkan 'Private' kepada pengguna
    ]
	status_surat = models.CharField(max_length=20, choices=STATUS_CHOICES, default='public')  # Default adalah Public
	class Meta:
		managed = False
		db_table = 'surat'
		# ordering = ['updated','created']
	# 
# 

class Suratf(CommonModel):
	_pk = models.AutoField(db_column='pk',primary_key=True)
	pk_surat = models.ForeignKey('Surat', models.DO_NOTHING, db_column='pk_surat')
	name = models.CharField(max_length=256, blank=True, null=True)
	path = models.CharField(max_length=512, blank=True, null=True)
	_type = models.CharField(db_column='type',max_length=128, blank=True, null=True)
	size = models.IntegerField(blank=True, null=True)
	is_deleted = models.BooleanField(default=False)
	class Meta:
		managed = False
		db_table = 'suratf'
		ordering = ['name']
	# 
# 

class Suratd(CommonModel):
	_pk = models.AutoField(db_column='pk',primary_key=True)
	pk_surat = models.ForeignKey('Surat', models.DO_NOTHING, db_column='pk_surat')
	kepada = models.CharField(max_length=256, blank=True, null=True)
	catatan = models.TextField(blank=True, null=True)

	class Meta:
		managed = False
		db_table = 'suratd'
		ordering = ['created']
	# 
# 

class Disposisi(CommonModel):
	_pk = models.AutoField(db_column='pk',primary_key=True)
	pk_surat = models.ForeignKey('Surat', models.DO_NOTHING, db_column='pk_surat', blank=True, null=True)
	tanggal = models.DateField()
	sifat = models.CharField(max_length=64, blank=True, null=True)
	kepada = models.TextField(blank=True, null=True)
	catatan = models.TextField(blank=True, null=True)
	user_input = models.TextField(blank=False, null=False)

	class Meta:
		managed = False
		db_table = 'disposisi'
		# ordering = ['tanggal','updated','created']
	# 
# 
class SuratVersion(models.Model):
    _pk = models.AutoField(db_column='pk', primary_key=True)
    pk_surat = models.IntegerField()
    nomor = models.CharField(max_length=128)
    tanggal = models.DateField()
    tanggal_masuk = models.DateField(blank=True, null=True)
    pengirim = models.CharField(max_length=128, blank=True, null=True)
    pengirim_nama = models.CharField(max_length=128, blank=True, null=True)
    pengirim_instansi = models.CharField(max_length=256, blank=True, null=True)
    penerima = models.CharField(max_length=128, blank=True, null=True)
    penerima_nama = models.CharField(max_length=128, blank=True, null=True)
    penerima_instansi = models.CharField(max_length=256, blank=True, null=True)
    sifat = models.CharField(max_length=64, blank=True, null=True)
    jenis = models.CharField(max_length=64, blank=True, null=True)
    perihal = models.TextField(blank=True, null=True)
    status_surat = models.CharField(max_length=20, blank=True, null=True)
    created = models.DateTimeField(auto_now_add=True)
    user_input = models.IntegerField(default=0)

    class Meta:
        managed = False
        db_table = 'surat_versions'  # ✅ fix disini


class SuratVersionAttachment(models.Model):
    _pk = models.AutoField(db_column='pk', primary_key=True)
    pk_version = models.ForeignKey('SuratVersion', db_column='pk_version', on_delete=models.CASCADE)
    name = models.CharField(max_length=256)
    path = models.CharField(max_length=512)
    _type = models.CharField(db_column='type', max_length=128, blank=True, null=True)
    size = models.IntegerField(blank=True, null=True)
    created = models.DateTimeField(auto_now_add=True)

    class Meta:
        managed = False
        db_table = 'surat_version_attachments'  # ✅ fix disini

class Tag(models.Model):
    id = models.AutoField(primary_key=True)
    name = models.CharField(max_length=64, unique=True)

    class Meta:
        managed = False  # <- ini penting!
        db_table = 'tags'


class ContentTag(models.Model):
    id = models.AutoField(primary_key=True)
    content = models.ForeignKey('Contents', models.DO_NOTHING, db_column='content_id')
    tag = models.ForeignKey(Tag, models.DO_NOTHING, db_column='tag_id')

    class Meta:
        managed = False  # <- ini juga penting
        db_table = 'content_tags'
        unique_together = (('content', 'tag'),)
