
import os,pprint,datetime
from django.utils.timezone import now
from django.db import connection
from django.conf import settings
from .models import (master as m_master)
from .func import dump
from django.contrib.humanize.templatetags.humanize import intcomma
from webapp.models.master import AuditLog
import fitz

dayList = {
    'Sun' : 'Minggu',
    'Mon' : 'Senin',
    'Tue' : 'Selasa',
    'Wed' : 'Rabu',
    'Thu' : 'Kamis',
    'Fri' : 'Jumat',
    'Sat' : 'Sabtu'
}
monthList = {
    'Jan': 'Januari',
    'Feb': 'Februari',
    'Mar': 'Maret',
    'Apr': 'April',
    'May': 'Mei',
    'Jun': 'Juni',
    'Jul': 'Juli',
    'Aug': 'Agustus',
    'Sep': 'September',
    'Oct': 'Oktober',
    'Nov': 'November',
    'Dec': 'Desember'
}

def update_tgl():
    now = datetime.datetime.now()
    hari = now.strftime("%a")
    tanggal = now.strftime("%d")
    bulan = now.strftime("%b")
    tahunsaiki = now.strftime("%Y")
    tglblntahun = tanggal+' '+monthList[bulan]+' '+tahunsaiki
    if hari == 'Jum':
        hari = 'Fri'
    tgl_lengkap = dayList[hari]+', '+tglblntahun
    return{"tgl_lengkap":tgl_lengkap,"tglblntahun":tglblntahun,"tahunsaiki":tahunsaiki}

def dateISO(date=None):
	if date is None:
		date = datetime.datetime.now()
	return date.isoformat()
# 
def dateFormatted(date=None,format='%Y-%m-%d %H:%M:%S'):
	if date is None:
		date = datetime.datetime.now()
	return datetime.datetime.strftime(date,format)
# 

def template_variables(request):
	session_current = dict(request.session.items())

	date_unique_current = dateFormatted(format='%Y-%m-%d %H')
	if settings.DEBUG:
		date_unique_current = dateISO()

	if session_current['sess_is_auth']:
		m_master.Menus._recursive_validate = lambda menu: m_master.Access._menus_validate(
			menus_pk=menu['pk'],
			roles_pk=session_current['pk_roles'],
			users_pk=session_current['pk'],
		)

	return {
		'debug': settings.DEBUG,
		'session_current': session_current,
		'settings_default': m_master.Settings._default(),
		'date_unique_current': date_unique_current,
		'layout_headbar': m_master.Menus._recursive(pk_parent=0,_is='t',_type='headbar'),
		'layout_sidebar': m_master.Menus._recursive(pk_parent=0,_is='t',_type='sidebar'),
	}
# 

"""
referensi
https://softwareengineering.stackexchange.com/q/200522

pemakaian
from gin.db import query_00
with query_00('SELECT * FROM master.settingtahun a where a.tahun = %s', [str(2019),]) as q:
	for b in q.result():
		print(b)
"""
class query_00:
	def __init__(self, db_sql, db_stmt=[], db_name=None, db_prepare=True):
		self.db_sql = db_sql
		self.db_stmt = db_stmt
		self.db_name = db_name
		self.db_prepare = db_prepare
		self.query = connection.cursor()

	# must return self because
	# AttributeError: 'NoneType' object has no attribute 'result'
	def __enter__(self):
		if self.db_prepare: self.query.execute(self.db_sql,self.db_stmt);
		else: self.query.execute(self.db_sql);

		if self.query and self.query.description: self.fields = [f.name for f in self.query.description];
		else: self.fields = [];

		return self

	# ripped from
	# https://github.com/django/django/blob/master/django/db/utils.py
	def __exit__(self, exc_type, exc_value, traceback):
		if self.query: self.query.close();

	def keyvalue(self,entry):
		return dict(zip(self.fields,entry))

	def result(self):
		for entry in self.query: yield self.keyvalue(entry);

	def result_one(self):
		entry = self.query.fetchone()
		return None if entry is None else self.keyvalue(entry)

	def result_all(self):
		return [b for b in self.result()]
# 


def currency(nominal):
    nominal = round(float(nominal), 2)
    return "Rp. %s%s" % (intcomma(int(nominal)), ("%0.2f" % nominal)[-3:])

arrBulan = {'01':'Januari', '02':'Februari', '03':'Maret', '04':'April', 
	'05':'Mei', '06':'Juni', '07':'Juli', '08':'Agustus',
    '09':'September', '10':'Oktober', '11':'November', '12':'Desember'}

def tgl_indo(tgl):
	pecah   = tgl.split("-")
	return pecah[2]+" "+arrBulan[pecah[1]]+" "+pecah[0]


def create_thumbnail(pdf, file_path=settings.FILE_DIR):
	pdffile = file_path+"/"+pdf
	img_name = pdf.split('.pdf')
	doc = fitz.open(pdffile)
	page = doc.load_page(0)  # number of page
	pix = page.get_pixmap()
	output = file_path+"/"+pdf+".png"
	pix.save(output)
	return 'Convert Berhasil '+output+''

def update_tgl():
    now = datetime.datetime.now()
    hari = now.strftime("%a")
    tanggal = now.strftime("%d")
    bulan = now.strftime("%b")
    tahunsaiki = now.strftime("%Y")
    jam = now.strftime("%H")
    menit = now.strftime("%M")
    detik = now.strftime("%S")
    tglblntahun = tanggal+' '+monthList[bulan]+' '+tahunsaiki
    tgldetik = tanggal+''+monthList[bulan]+''+tahunsaiki+''+jam+''+menit+''+detik
    if hari == 'Jum':
        hari = 'Fri'
    tgl_lengkap = dayList[hari]+', '+tglblntahun
    return{"tgl_lengkap":tgl_lengkap,"tglblntahun":tglblntahun,"tahunsaiki":tahunsaiki,"tgldetik":tgldetik, }

def log_activity(request, action, content_type, object_pk, description):
    print('📣 log_activity dipanggil:', action, content_type, object_pk, description)  # 👈 DEBUG

    try:
        user_id = request.session.get('pk')

        AuditLog.objects.create(
                user_id=user_id,
                action=action,
                content_type=content_type,
                object_pk=object_pk,
                description=description,
                timestamp=now()
            )


    except Exception as e:
        print('❌ Gagal mencatat log:', e)

