
CREATE SEQUENCE IF NOT EXISTS surat_pk_ai; COMMIT;

CREATE TABLE IF NOT EXISTS surat (
	pk INTEGER NOT NULL DEFAULT nextval('surat_pk_ai'),
	"type" VARCHAR(64) NOT NULL,
	nomor VARCHAR(128) NOT NULL,
	tanggal DATE NOT NULL,
	tanggal_masuk DATE DEFAULT NULL,
	pengirim VARCHAR(128),
	pengirim_nama VARCHAR(128),
	pengirim_instansi VARCHAR(256),
	penerima VARCHAR(128),
	penerima_nama VARCHAR(128),
	penerima_instansi VARCHAR(256),
	sifat VARCHAR(64),
	jenis VARCHAR(64),
	perihal TEXT DEFAULT NULL,
	created TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
	updated TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
	user_input INTEGER DEFAULT 0,
	CONSTRAINT surat_pk PRIMARY KEY (pk)
	-- CONSTRAINT surat_unique UNIQUE ("type",nomor,tanggal) /* todo */
);
COMMIT;

ALTER SEQUENCE surat_pk_ai OWNED BY surat.pk; COMMIT;

ALTER TABLE surat ADD COLUMN IF NOT EXISTS "type" VARCHAR(64); COMMIT;
ALTER TABLE surat ALTER COLUMN "type" SET NOT NULL; COMMIT;
ALTER TABLE surat ADD COLUMN IF NOT EXISTS "user_input" INTEGER DEFAULT 0; COMMIT;
ALTER TABLE surat ALTER COLUMN nomor SET NOT NULL; COMMIT;
ALTER TABLE surat ALTER COLUMN tanggal SET NOT NULL; COMMIT;

ALTER TABLE surat ADD COLUMN IF NOT EXISTS pengirim_nama VARCHAR(128); COMMIT;
ALTER TABLE surat ADD COLUMN IF NOT EXISTS pengirim_instansi VARCHAR(256); COMMIT;

ALTER TABLE surat ADD COLUMN IF NOT EXISTS penerima_nama VARCHAR(128); COMMIT;
ALTER TABLE surat ADD COLUMN IF NOT EXISTS penerima_instansi VARCHAR(256); COMMIT;

ALTER TABLE surat ADD COLUMN IF NOT EXISTS tanggal_masuk DATE DEFAULT NULL; COMMIT;

COMMENT ON COLUMN surat.tanggal IS 'TANGGAL PADA SURAT';
COMMENT ON COLUMN surat.tanggal_masuk IS 'TANGGAL TERIMA UNTUK SURAT MASUK';
