
CREATE SEQUENCE IF NOT EXISTS attachments_pk_ai; COMMIT;

CREATE TABLE IF NOT EXISTS attachments (
	pk INTEGER NOT NULL DEFAULT nextval('attachments_pk_ai'),
	pk_contents INTEGER NOT NULL,
	"name" VARCHAR(256) DEFAULT NULL,
	"path" VARCHAR(512) DEFAULT NULL,
	"type" VARCHAR(128) DEFAULT NULL,
	"size" INTEGER DEFAULT 0,
	created TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
	updated TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
	CONSTRAINT attachments_pk PRIMARY KEY (pk),
	CONSTRAINT attachments_contents_fk FOREIGN KEY (pk_contents) REFERENCES contents (pk) ON DELETE CASCADE ON UPDATE CASCADE
);
COMMIT;

ALTER SEQUENCE attachments_pk_ai OWNED BY attachments.pk; COMMIT;
