
CREATE SEQUENCE IF NOT EXISTS skpd_dg_pk_ai; COMMIT;

CREATE TABLE IF NOT EXISTS skpd_dg (
	pk INTEGER NOT NULL DEFAULT NEXTVAL('skpd_dg_pk_ai'),
	kd_urusan INTEGER DEFAULT NULL,
	kd_bidang INTEGER DEFAULT NULL,
	kd_unit INTEGER DEFAULT NULL,
	kd_sub INTEGER DEFAULT NULL,
	kd_all VARCHAR(128) NOT NULL,
	urai VARCHAR(256) NOT NULL,
	created TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
	updated TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
	CONSTRAINT skpd_dg_pk PRIMARY KEY (pk)
);
COMMIT;

ALTER SEQUENCE skpd_dg_pk_ai OWNED BY skpd_dg.pk; COMMIT;
DO $exec$ BEGIN
	IF NOT EXISTS(SELECT * FROM skpd_dg)
	THEN
		INSERT INTO skpd_dg (kd_urusan,kd_bidang,kd_unit,kd_sub,kd_all,urai) VALUES
		(1,1,1,1,'1.1.1.1','Dinas Pendidikan Pemuda dan Olahraga'),
		(1,2,1,1,'1.2.1.1','Dinas Kesehatan'),
		(1,2,2,1,'1.2.2.1','Rumah Sakit Umum Daerah'),
		(1,3,1,1,'1.3.1.1','Dinas Pekerjaan Umum Dan Penataan Ruang'),
		(1,4,1,1,'1.4.1.1','Dinas Perumahan Dan Kawasan Permukiman'),
		(1,5,1,1,'1.5.1.1','Kantor Satuan Polisi Pamong Praja'),
		(1,5,2,1,'1.5.2.1','Kantor Kesatuan Bangsa Dan Perlindungan Masyarakat'),
		(1,6,1,1,'1.6.1.1','Dinas Sosial'),
		(2,1,1,1,'2.1.1.1','Dinas Tenaga Kerja'),
		(2,2,1,1,'2.2.1.1','Dinas Pemberdayaan Perempuan, Perlindungan Anak dan Keluarga Berencana'),
		(2,3,1,1,'2.3.1.1','Dinas Ketahanan Pangan'),
		(2,5,1,1,'2.5.1.1','Dinas Lingkungan Hidup'),
		(2,6,1,1,'2.6.1.1','Dinas Kependudukan Dan Pencatatan Sipil'),
		(2,7,1,1,'2.7.1.1','Dinas Pemberdayaan Masyarakat dan  Kampung'),
		(2,9,1,1,'2.9.1.1','Dinas Perhubungan'),
		(2,10,1,1,'2.10.1.1','Dinas Komunikasi Dan Informatika'),
		(2,11,1,1,'2.11.1.1','Dinas Koperasi Dan Usaha Kecil Dan Menengah'),
		(2,12,1,1,'2.12.1.1','Dinas Penanaman Modal Dan Pelayanan Terpadu Satu Pintu'),
		(2,17,1,1,'2.17.1.1','Dinas Perpustakaan Dan Arsip Daerah'),
		(3,1,1,1,'3.1.1.1','Dinas Peternakan dan Perikanan'),
		(3,2,1,1,'3.2.1.1','Dinas Kebudayaan Dan Pariwisata'),
		(3,3,1,1,'3.3.1.1','Dinas Pertanian dan Perkebunan'),
		(3,6,1,1,'3.6.1.1','Dinas Perindustrian Perdagangan dan Koperasi'),
		(4,1,1,1,'4.1.1.1','Dewan Perwakilan Rakyat Daerah'),
		(4,1,2,1,'4.1.2.1','Kepala Daerah dan Wakil Kepala Daerah'),
		(4,1,3,1,'4.1.3.1','Sekretariat Daerah'),
		(4,1,4,1,'4.1.4.1','Sekretariat Dewan Perwakilan Rakyat Daerah'),
		(4,1,6,1,'4.1.6.1','Badan Pengelola Bencana Daerah'),
		(4,1,7,1,'4.1.7.1','Distrik KAMU'),
		(4,1,8,1,'4.1.8.1','Distrik MAPIA'),
		(4,1,9,1,'4.1.9.1','Distrik KAMU UTARA'),
		(4,1,10,1,'4.1.10.1','Distrik PIYAIYE'),
		(4,1,11,1,'4.1.11.1','Distrik KAMU SELATAN'),
		(4,1,12,1,'4.1.12.1','Distrik Mapia Barat'),
		(4,1,13,1,'4.1.13.1','Distrik KAMU TIMUR'),
		(4,1,14,1,'4.1.14.1','Distrik MAPIA TENGAH'),
		(4,1,15,1,'4.1.15.1','Distrik SUKIKAI SELATAN'),
		(4,1,16,1,'4.1.16.1','Distrik DOGIYAI'),
		(4,2,1,1,'4.2.1.1','Inspektorat'),
		(4,3,1,1,'4.3.1.1','Badan Perencanaan Pembangunan Daerah dan Penelitian Pengembangan'),
		(4,4,1,1,'4.4.1.1','Badan Pengelolaan Keuangan dan Aset Daerah'),
		(4,4,1,2,'4.4.1.2','Satuan Kerja Pengelola Keuangan Daerah'),
		(4,4,2,1,'4.4.2.1','Badan Pelayanan Pajak Dan Retribusi Daerah'),
		(4,5,1,1,'4.5.1.1','Badan Kepegawaian Daerah Dan Pengembangan Sumber Daya Manusia')
		 ON CONFLICT DO NOTHING;
	END IF;
END $exec$;