
window.webapp = window.webapp || {};

/* image yang browser bisa */
/* https://developer.mozilla.org/en-US/docs/Web/Media/Formats/Image_types */
window.webapp.image_extension_re = /\.(bmp|a?png|jpe?g|gif|ico|cur|jfif|pjpeg|pjp|svg|webp)$/;
/* video yang browser bisa */
/* https://developer.mozilla.org/en-US/docs/Web/Media/Formats/Containers#Browser_compatibility */
window.webapp.video_extension_re = /\.(3gp|mpe?g|mp4|m4v|m4p|ogm|ogv|ogg|mov|webm)$/;
window.webapp.audio_extension_re = /\.(aaac|flac|wav|mp3|opus)$/;

if (!('debug' in window.webapp)) window.webapp.debug = false;

window.dump = function() {
	Array.from(arguments).forEach(i => console[window.dump.use_trace ? 'trace' : 'debug'](i));
};
window.dump.use_trace = false;

window.cukimay = function(name) {
	var cookies = {};

	document.cookie.split(';').forEach(cookie => {
		cookie = cookie.split('=');
		if (cookie[0] && cookie[0].trim()) {
			cookies[cookie[0].trim()] = cookie[1] || null;
		}
	});

	if (name) return (cookies[name] || null);
	return cookies;
}

window.webapp.slug_ = data => {
	return data.trim().toLowerCase()
	.replace(/[^a-z0-9]/g,'_')
	.replace(/_{2,}/g,'_')
	.replace(/^_/,'')
	.replace(/_$/,'')
	;
};

// https://davidwalsh.name/javascript-debounce-function
window.webapp.debounce = (func,wait,immediate) => {
	var timeout;
	return function() {
		var context = this, args = arguments;
		var later = function() {
			timeout = null;
			if (!immediate) func.apply(context,args);
		};
		var callNow = immediate && !timeout;
		clearTimeout(timeout);
		timeout = setTimeout(later,wait);
		if (callNow) func.apply(context, args);
	};
};
