'use strict';

(unknown => {
	var toast = document.getElementById('toast_simple');

	$(toast).toast({
		animation:true,
		autohide:true,
		delay:3900,
	});

	var func = function() {
		this.dom = toast;
		this.move('bottom,right');
		this.theme('webapp');
	};

	func.prototype.move = function(direction,custom) {
		direction = String(direction).toLowerCase();
		custom = custom || {};

		let match;

		match = direction.match(/top|bottom/);
		if (match) {
			toast.style[match[0]] = '4vh';
		}

		match = direction.match(/left|right/);
		if (match) {
			toast.style[match[0]] = '2.50vw';
		}

		for (var i in custom) toast.custom[i] = custom[i];

		return this;
	};

	func.prototype.theme = function(theme) {
		theme = (theme || 'default').toLowerCase();

		toast.style['background-color'] = `var(--${theme})`;

		toast.style.color = 'var(--light)';

		if (/^light|warning|yellow|orange$/.test(theme)) {
			toast.style.color = 'var(--dark)';
		}

		return this;
	};

	func.prototype.show = function() {
		$(toast).toast('show');
		return this;
	};
	func.prototype.hide = function() {
		$(toast).toast('hide');
		return this;
	};

	func.prototype.text = function(content) {
		$(toast).find('[data-content]').text(content);
		return this;
	};
	func.prototype.html = function(content) {
		$(toast).find('[data-content]').html(content);
		return this;
	};

	window.Toaster_Simple = new func;
})();

/*

window.Toaster_Simple.text('hello world').html(`<b>Hello World</b>`).show();

*/