'use strict';

(unknown => {

	var preview = document.getElementById('preview');
	var $preview = $(preview).modal({
		show: false,
		focus: false,
		keyboard: false,
		backdrop: 'static',
	});

	var func = function(list) {
		this.reset();
		this.init(list);
	};
	func.prototype.init = function(list) {
		this.list = list || [];
		this.reset();
	};
	func.prototype.show = function() {
		$preview.modal('show');
	};
	func.prototype.hide = function() {
		$preview.modal('hide');
		this.reset();
	};
	func.prototype.goto = function(page) {
		page = page || 0;

		this.reset();
		if (this.list.length === 0) return;

		this.page = page;

		var item = this.list[page];
		if (item) {
			$preview.find('[data-name]').text(item.name);
			$preview.find('[data-download]').attr('download',item.name).attr('href',item.href).show();

			if (window.webapp.image_extension_re.test(item.href))
				return this.mode_image(item);

			if (window.webapp.video_extension_re.test(item.href) || window.webapp.audio_extension_re.test(item.href))
				return this.mode_iframe(item);

			if (/\.(html?|css|js|txt|pdf)$/.test(item.href))
				return this.mode_iframe(item);

			return this.mode_unkonwn(item);
		}
	};
	func.prototype.mode_image = function(data) {
		$preview.find('[data-mode=image]').each(function() {
			$(this).show().prop(this.dataset.href,data.href);
		});
	};
	func.prototype.mode_iframe = function(item) {
		$preview.find('[data-mode=iframe]').show().find('[data-href]').each(function() {
			$(this).prop(this.dataset.href,item.href);
		});
	};

	func.prototype.mode_unkonwn = function(item) {
		$preview.find('[data-mode=unknown]').show().find('[data-href]');
	};

	func.prototype.reset = function() {
		this.page = null;
		$preview.find('[data-download]').hide();
		$preview.find('[data-mode]').hide();
		$preview.find('[data-href]').each(function() {
			$(this).removeAttr(this.dataset.href);
		});
	};

	window.Previewer = new func;

	$preview.find('[data-page]').on('click',function(event) {
		event.preventDefault();

		let page = 0;
		if (this.dataset.page === 'prev') page = -1;
		if (this.dataset.page === 'next') page = +1;
		page = window.Previewer.page+page;
		if (page > window.Previewer.list.length-1) page = 0;
		if (page < 0) page = window.Previewer.list.length-1;
		window.Previewer.goto(page);
	});
})();

/*
Previewer.init([
	{name:'background',href:'http://localhost:9000/assets/upload/site-bg.png'},
	{name:'my cv v4',href:'http://localhost:9000/assets/resources/2020/06/08/1bb13d1736518e62893994d7c47745a9.pdf'},
]);

Previewer.show();
Previewer.goto();
Previewer.hide();
*/
