'use strict';

(unknown => {
	var form = document.getElementById('upload');
	var $form = $(form);
	var $exec = $('#upload_exec');
	var $toast = $('#upload_toast').toast({animation:true,autohide:true,delay:5000});
	var $attachments_wrap = $('#attachments_wrap');
	var $attachments_list = $('#attachments_list');
	var $attributes_list = $('#attributes_list');

	var $attachments_wait = $('#attachments_wait').modal({
		show: false,
		keyboard: false,
		backdrop: 'static',
	});

	var is_busy = false;
	window.onbeforeunload = function(event) {
		// event.preventDefault();
		if (is_busy) return 'Anda Yakin Menutup Laman Ini?';
	};

	$form.on('submit',event => {
		event.preventDefault();

		if (form.checkValidity() === false) return form.reportValidity();

		$.ajax({
			url: $form.prop('action'),
			method: $form.prop('method'),
			processData: false,
			contentType: false,
			data: new FormData($form.get(0)),
			xhr: function() {
				let xhr = $.ajaxSettings.xhr();
				is_busy = true;

				$attachments_wait.find('[data-wait]').css('width','0%').text('0%');

				$(xhr.upload).on('progress',jq_event => {
					let upload_event = jq_event.originalEvent;
					if (upload_event.lengthComputable) {
						$attachments_wait.modal('show');

						let percent = window.Math.round((upload_event.loaded / upload_event.total) * 100);

						$attachments_wait.find('[data-wait]').css('width', `${percent}%`).text(`${percent}%`);
					}
				});

				return xhr;
			},
			success: result => {
				is_busy = false;
				if ($.isPlainObject(result) && result.redirect) {
					window.location.replace(result.redirect);
				}
			},
			error: (jqxhr,textStatus,errorthrown) => {
				dump(jqxhr,textStatus,errorthrown);

				is_busy = false;
				let message = 'Gagal Upload.\n';

				if (jqxhr.responseJSON && $.isPlainObject(jqxhr.responseJSON)) {
					let result = jqxhr.responseJSON;
					if (result.message) message = `${message}${result.message}\n`;
				}

				alert(message);
			},
			complete: jqxhr => {
				is_busy = false;
				$attachments_wait.modal('hide');
			},
		});
	});

$exec.find('[data-delete]').each(function() {
	$(this).prop('href',this.dataset.delete).on('click',event => {
		let message = `Anda Yakin Untuk Hapus Berkas Ini Beserta Lampirannya ?\nData Yang Sudah Dihapus Tidak Bisa Dikembalikan.`;
		if (window.confirm(message) === false) event.preventDefault();
	});
});

$attachments_list.find('[data-attachment-new]').each(function() {
	let template = this.cloneNode(true); template.removeAttribute('hidden'); this.remove();

	$($attachments_wrap).find('[data-deploy]').on('click',event => {
		$( template.cloneNode(true) ).appendTo( $attachments_list ).each(function() {
			$(this).find('[data-destroy]').on('click',event => $(this).remove());
		});
		bsCustomFileInput.init();
	});
});

$attachments_list.find('[data-attachment-old]').each(function() {
	var wrap = this;
	$(this).find('[data-destroy]').on('click',event => {
		let href = event.currentTarget.dataset.destroy;
		let message = `Anda Yakin Untuk Hapus File "${wrap.dataset.name}" ?\nData Yang Sudah Dihapus Tidak Bisa Dikembalikan.`;
		if (window.confirm(message)) {
			$.post(href,result => {
				$toast.find('[data-message]').html(`Berhasil Hapus File <b>${wrap.dataset.name}</b>`);
				$toast
				.css({'background-color':'var(--info)','color':'var(--light)'})
				.toast('show')
				;
				$(wrap).remove();
			}).fail(() => {
				$toast.find('[data-message]').text(`Gagal Hapus File`);
				$toast
				.css({'background-color':'var(--warning)','color':'var(--dark)'})
				.toast('show')
				;
			}).complete(event => {
				$attachments_list.trigger('preview');
			});
		}
	});
});
$attachments_list.on('preview',function() {
	let list = [];

	$attachments_list.find('[data-attachment-old]').each(function(i) {
		let item = {
			name: this.dataset.name,
			href: $(this).find('[href]').prop('href'),
		};
		list.push(item);

		$(this).find('[data-preview]').attr('onclick',`window.Previewer.show();window.Previewer.goto(${i});`);
	});
	window.Previewer.init(list);
}).trigger('preview');

var attribute_template;
$attributes_list.find('[data-template]').each(function() {
	attribute_template = this.cloneNode(true);
	this.remove();
});

var attributes_meta,attributes_data;
attributes_meta = $('#attributes_meta').prop('textContent');
attributes_meta = JSON.parse(attributes_meta) || {};
attributes_data = $('#attributes_data').prop('textContent');
attributes_data = JSON.parse(attributes_data);
if (typeof attributes_data === 'string') attributes_data = JSON.parse(attributes_data);
attributes_data = attributes_data || {};

$form.find('[name=attributes]').prop('value',JSON.stringify(attributes_data));

var attribute_init = (pk_categories) => {
	$attributes_list.find('[data-template]').remove();
	if (pk_categories === unknown || pk_categories === null || pk_categories === '') return;

	var meta = attributes_meta[pk_categories];
	if (meta === unknown || meta === null) return;

	for (var m in meta) {
		$( attribute_template.cloneNode(true) ).appendTo( $attributes_list ).each(function() {
			var nick = `${meta[m].name}`;
			$(this).find('[data-text-name]').text(nick);

			$(this).find('[data-type]').each(function() {
				if (this.dataset.type !== meta[m].type) {
					$(this).remove();
					return;
				}

				this.dataset.pk = m;
				if (m in attributes_data) {
					this.value = attributes_data[m];
				}

				$(this).prop('title',nick).prop('placeholder',nick);

				$(this).on('change',function() {
					attribute_exec(this.dataset.pk,this.value);
				});
				$(this).on('input',window.webapp.debounce(function() {
					attribute_exec(this.dataset.pk,this.value);
				},100));
			});
		});
	}
};

var attribute_exec = (k,v) => {
	attributes_data[k] = v;

	$form.find('[name=attributes]').prop('value',JSON.stringify(attributes_data));

	dump(attributes_data);
};

$form.find('[name=pk_categories]').each(function() {
	$(this).on('change', function() {
		attribute_init(this.value);
	});
	$(this).trigger('change');
});

})();
